# the randomLCA library may be obtained from CRAN http://cran.r-project.org/
library(randomLCA)

# the symptoms data should also be available with the randomLCA library
# in which case the following statement is unnecessary
symptoms <- read.table("symptoms.txt",sep="\t",header=TRUE)

# LC models
symptoms.lca1 <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,nclass=1)
symptoms.lca2 <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,nclass=2)
symptoms.lca3 <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,nclass=3)
symptoms.lca4 <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,nclass=4)
symptoms.lca5 <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,nclass=5)

#LCRE models
symptoms.lca1random <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,initmodel=symptoms.lca1,random=TRUE,nclass=1,blocksize=4)
symptoms.lca2random <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,initmodel=symptoms.lca2,random=TRUE,nclass=2,blocksize=4)
symptoms.lca3random <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,initmodel=symptoms.lca3,random=TRUE,nclass=3,blocksize=4)
symptoms.lca4random <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,initmodel=symptoms.lca4,random=TRUE,nclass=4,blocksize=4)
symptoms.lca5random <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,initmodel=symptoms.lca5,random=TRUE,nclass=5,blocksize=4)

#LC2RE models
symptoms.lca1random2 <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,initmodel=symptoms.lca1random,random=TRUE,level2=TRUE,nclass=1,blocksize=4)
symptoms.lca2random2 <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,initmodel=symptoms.lca2random,random=TRUE,level2=TRUE,nclass=2,blocksize=4)
symptoms.lca3random2 <- randomLCA(symptoms[,1:16],freq=symptoms$Freq,initmodel=symptoms.lca3random,random=TRUE,level2=TRUE,nclass=3,blocksize=4)
